﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using Inet.Viewer.Data;
using System;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// A progress for searches which encapsulates a search loader instance.
    /// </summary>
    public class SearchProgress: Progress
    {
        private SearchLoader searchLoader;

        /// <summary>
        /// Creates a search progress instance.
        /// </summary>
        /// <param name="errorDelegate">the error delegate</param>
        /// <param name="searchLoader">the search loader instance to run</param>
        public SearchProgress(Action<Exception> errorDelegate, SearchLoader searchLoader)
            : base(errorDelegate, ProgressType.Search)  
        {
            this.searchLoader = searchLoader;
        }

        /// <inheritdoc />
        public override string Name
        {
            get
            {
                return Inet.Viewer.Resources.strings.ProgressSearch;
            }
        }

        /// <inheritdoc />
        protected override void Run()
        {
            try
            {
                searchLoader.Run();
                Status = ProgressStatus.Completed;
            }
            catch (Exception e)
            {
                ShowError(e);
                Status = ProgressStatus.Error;
            }
        }

        /// <inheritdoc />
        public override void Cancel()
        {
            Status = ProgressStatus.Canceled;
            searchLoader.Cancel();
        }
    }
}
